/*!
 * MotionFlow v1.0.0
 * Lightweight motion library for scroll animations, parallax, text effects, counters, and tickers
 * https://motionflow.dev
 *
 * Copyright (c) 2026 Deepak Verma
 * 
 * Released under the MIT License
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):(e="undefined"!=typeof globalThis?globalThis:e||self).MotionFlow=t()}(this,function(){"use strict";const e={linear:"linear",ease:"ease","ease-in":"ease-in","ease-out":"ease-out","ease-in-out":"ease-in-out","ease-in-back":"cubic-bezier(0.6, -0.28, 0.735, 0.045)","ease-out-back":"cubic-bezier(0.175, 0.885, 0.32, 1.275)","ease-in-out-back":"cubic-bezier(0.68, -0.55, 0.265, 1.55)","ease-in-sine":"cubic-bezier(0.47, 0, 0.745, 0.715)","ease-out-sine":"cubic-bezier(0.39, 0.575, 0.565, 1)","ease-in-out-sine":"cubic-bezier(0.445, 0.05, 0.55, 0.95)","ease-in-quad":"cubic-bezier(0.55, 0.085, 0.68, 0.53)","ease-out-quad":"cubic-bezier(0.25, 0.46, 0.45, 0.94)","ease-in-out-quad":"cubic-bezier(0.455, 0.03, 0.515, 0.955)","ease-in-cubic":"cubic-bezier(0.55, 0.055, 0.675, 0.19)","ease-out-cubic":"cubic-bezier(0.215, 0.61, 0.355, 1)","ease-in-out-cubic":"cubic-bezier(0.645, 0.045, 0.355, 1)","ease-in-quart":"cubic-bezier(0.895, 0.03, 0.685, 0.22)","ease-out-quart":"cubic-bezier(0.165, 0.84, 0.44, 1)","ease-in-out-quart":"cubic-bezier(0.77, 0, 0.175, 1)","ease-in-quint":"cubic-bezier(0.755, 0.05, 0.855, 0.06)","ease-out-quint":"cubic-bezier(0.23, 1, 0.32, 1)","ease-in-out-quint":"cubic-bezier(0.86, 0, 0.07, 1)","ease-in-expo":"cubic-bezier(0.95, 0.05, 0.795, 0.035)","ease-out-expo":"cubic-bezier(0.19, 1, 0.22, 1)","ease-in-out-expo":"cubic-bezier(1, 0, 0, 1)","ease-in-circ":"cubic-bezier(0.6, 0.04, 0.98, 0.335)","ease-out-circ":"cubic-bezier(0.075, 0.82, 0.165, 1)","ease-in-out-circ":"cubic-bezier(0.785, 0.135, 0.15, 0.86)","ease-in-elastic":"cubic-bezier(0.7, -0.6, 0.32, 1.6)","ease-out-elastic":"cubic-bezier(0.33, 0.7, 0.67, -0.7)","ease-in-out-elastic":"cubic-bezier(0.7, -0.5, 0.25, 1.6)","ease-in-bounce":"cubic-bezier(0.6, -0.28, 0.735, 0.045)","ease-out-bounce":"cubic-bezier(0.175, 0.885, 0.32, 1.275)","ease-in-out-bounce":"cubic-bezier(0.68, -0.55, 0.265, 1.55)"};function t(t={}){const n=!1,a=100,i=600,r=0,o="ease",s="top 90%",l="both",c=0,d=100;let u=[],m=!1,f=null,p=null,g=null,h=null;const b=e=>{const t=Number(e);return Number.isFinite(t)?t:void 0};function y(e){if(!e)return{elementAnchor:"top",viewportAnchor:70};const t=e.trim().toLowerCase().split(/\s+/);return{elementAnchor:t[0]||"top",viewportAnchor:t[1]?.endsWith("%")?parseInt(t[1]):{top:0,center:50,bottom:100}[t[1]]??70}}function w(){clearTimeout(h),h=setTimeout(v,60)}function v(){if(!u.length)return;const e=window.innerHeight,t=1.2*e;u.forEach(n=>{const a=n.el;if(!document.documentElement.contains(a))return;const i=(a.__mfStaggerParent||a).getBoundingClientRect();if(i.top>e+t||i.bottom<-t)return;const r=function(e,t){return"center"===t?e.top+e.height/2:"bottom"===t?e.bottom:e.top}(i,n.trigger.elementAnchor),o=r<e*n.trigger.viewportAnchor/100&&i.bottom>0,s=i.bottom<=0,l=i.top>=e;o&&!n.triggered&&(n.triggered=!0,function(e){e.style.willChange="transform, opacity";const t=()=>{e.style.willChange="",e.removeEventListener("animationend",t)};e.addEventListener("animationend",t)}(a),a.classList.add("mf-animate")),n.once||("top"===n.repeat&&s||"bottom"===n.repeat&&l||"both"===n.repeat&&(s||l))&&(n.triggered=!1,a.classList.remove("mf-animate"))})}function S(){u=[],m=!1;const h=document.body,S=!0===t.animation?{}:t.animation||{},A=S.stagger||{},T={once:S.once??n,distance:b(S.distance??a),duration:b(S.duration??i),delay:b(S.delay??r),easing:S.easing??o,trigger:S.trigger??s,repeat:S.repeat??l};h.style.setProperty("--mf-distance",T.distance+"px"),h.style.setProperty("--mf-duration",T.duration+"ms"),h.style.setProperty("--mf-delay",T.delay+"ms"),h.style.setProperty("--mf-easing",e[T.easing]||T.easing),document.querySelectorAll("[data-mf-animation]").forEach(e=>{e.__mfStaggerParent&&(delete e.__mfStaggerParent,delete e.dataset.mfAnimation,delete e.dataset.mfAnimationDelay,delete e.dataset.mfAnimationDistance,delete e.dataset.mfAnimationDuration,delete e.dataset.mfAnimationEasing,delete e.dataset.mfAnimationOnce,delete e.dataset.mfAnimationRepeat)});const x=new Map;document.querySelectorAll("[data-mf-stagger-animation]").forEach(e=>{const t=e.dataset.mfStaggerAnimation,n=b(e.dataset.mfStaggerDelay)??b(A.delay)??T.delay??c,a=b(e.dataset.mfStaggerGap)??b(A.gap)??d,i=b(e.dataset.mfStaggerDistance)??b(A.distance)??T.distance,r=b(e.dataset.mfStaggerDuration)??b(A.duration)??T.duration,o=e.dataset.mfStaggerEasing??A.easing??T.easing,s=e.dataset.mfStaggerOnce??A.once??T.once,l=e.dataset.mfStaggerRepeat??A.repeat??T.repeat,u=y(e.dataset.mfStaggerTrigger??A.trigger??T.trigger);x.set(e,u),Array.from(e.children).forEach((c,d)=>{c.hasAttribute("data-mf-stagger-ignore")||c.hasAttribute("data-mf-animation")||(c.__mfStaggerParent=e,c.dataset.mfAnimation=t,c.dataset.mfAnimationDelay=n+d*a,void 0!==i&&(c.dataset.mfAnimationDistance=i),void 0!==r&&(c.dataset.mfAnimationDuration=r),o&&(c.dataset.mfAnimationEasing=o),void 0!==s&&(c.dataset.mfAnimationOnce=s),l&&(c.dataset.mfAnimationRepeat=l))})}),document.querySelectorAll("[data-mf-animation]").forEach(t=>{t.dataset.mfAnimation&&(t.classList.add("mf-init"),t.dataset.mfAnimationDistance&&t.style.setProperty("--mf-distance",t.dataset.mfAnimationDistance+"px"),t.dataset.mfAnimationDuration&&t.style.setProperty("--mf-duration",t.dataset.mfAnimationDuration+"ms"),t.dataset.mfAnimationDelay&&t.style.setProperty("--mf-delay",t.dataset.mfAnimationDelay+"ms"),t.dataset.mfAnimationEasing&&t.style.setProperty("--mf-easing",e[t.dataset.mfAnimationEasing]||t.dataset.mfAnimationEasing),u.push({el:t,once:void 0!==t.dataset.mfAnimationOnce?"true"===t.dataset.mfAnimationOnce||""===t.dataset.mfAnimationOnce:T.once,repeat:(t.dataset.mfAnimationRepeat??T.repeat).toLowerCase(),trigger:t.__mfStaggerParent?x.get(t.__mfStaggerParent):y(t.dataset.mfAnimationTrigger??T.trigger),triggered:t.classList.contains("mf-animate")}))}),f=()=>{m||(requestAnimationFrame(()=>{v(),m=!1}),m=!0)},p=v,v(),window.addEventListener("scroll",f,{passive:!0}),window.addEventListener("resize",p),g||(g=new MutationObserver(w),g.observe(document.body,{childList:!0,subtree:!0,attributes:!0,attributeFilter:["data-mf-animation"]}))}function A(e=!0){window.removeEventListener("scroll",f),window.removeEventListener("resize",p),g?.disconnect(),g=null,clearTimeout(h),e&&u.forEach(({el:e})=>{e.classList.remove("mf-init","mf-animate"),e.style.removeProperty("--mf-distance"),e.style.removeProperty("--mf-duration"),e.style.removeProperty("--mf-delay"),e.style.removeProperty("--mf-easing"),e.style.willChange=""}),u=[],m=!1}return S(),{refresh:function(){v()},destroy:A,reinit:function(){A(!1),S()}}}function n(e={}){let t=[],n="undefined"!=typeof window?window.scrollY:0,a=!1,i=!1,r=null,o=null,s=null;const l="undefined"!=typeof window&&window.matchMedia("(prefers-reduced-motion: reduce)").matches,c=window.innerWidth<768?.14:.1,d={speed:1,tabletSpeed:0,mobileSpeed:0,breakpoints:{mobile:768,tablet:1024},stagger:{speed:0,tabletSpeed:0,mobileSpeed:0,step:.3,tabletStep:.2,mobileStep:.1,direction:"left"}},u={...d,...e.parallax||{},breakpoints:{...d.breakpoints,...e.parallax&&e.parallax.breakpoints||{}},stagger:{...d.stagger,...e.parallax&&e.parallax.stagger||{}}};function m(e){if("true"===e.dataset.mfParallaxLocked){const t=parseFloat(e.dataset.mfParallaxSpeed);return Number.isFinite(t)?t:0}const t=window.innerWidth;let n=t<=u.breakpoints.mobile&&null!=e.dataset.mfParallaxSpeedMobile?parseFloat(e.dataset.mfParallaxSpeedMobile):t<=u.breakpoints.tablet&&null!=e.dataset.mfParallaxSpeedTablet?parseFloat(e.dataset.mfParallaxSpeedTablet):null!=e.dataset.mfParallaxSpeed?parseFloat(e.dataset.mfParallaxSpeed):t<=u.breakpoints.mobile?u.mobileSpeed:t<=u.breakpoints.tablet?u.tabletSpeed:u.speed;return Number.isFinite(n)?n:0}function f(e){return e.getBoundingClientRect().top+window.scrollY}function p(){function e(){const e=n,i=window.innerHeight,o=.3*i;t.forEach(t=>{const n=t.el.getBoundingClientRect();if(n.top>i+o||n.bottom<-o)return;const a=t.docTop-i,r=e-a,s=Math.max(0,r);t.targetY=-Math.round(s*t.speed*.1*100)/100}),r||(r=requestAnimationFrame(d)),a=!1}function d(){let e=!1;t.forEach(t=>{var n,a;t.currentY=(n=t.currentY,a=t.targetY,n+(a-n)*c),Math.abs(t.currentY-t.targetY)>.1&&(e=!0),t.el.style.transform=`translate3d(0, ${t.currentY}px, 0)`}),r=e?requestAnimationFrame(d):null}i||l||(i=!0,t=[],a=!1,document.querySelectorAll("[data-mf-parallax-stagger]").forEach(e=>{const t=function(e){const t=window.innerWidth;let n=t<=u.breakpoints.mobile&&null!=e.dataset.mfParallaxStaggerSpeedMobile?parseFloat(e.dataset.mfParallaxStaggerSpeedMobile):t<=u.breakpoints.tablet&&null!=e.dataset.mfParallaxStaggerSpeedTablet?parseFloat(e.dataset.mfParallaxStaggerSpeedTablet):null!=e.dataset.mfParallaxStaggerSpeed?parseFloat(e.dataset.mfParallaxStaggerSpeed):t<=u.breakpoints.mobile?u.stagger.mobileSpeed:t<=u.breakpoints.tablet?u.stagger.tabletSpeed:u.stagger.speed;return Number.isFinite(n)?n:0}(e),n=function(e){const t=window.innerWidth;let n=t<=u.breakpoints.mobile&&null!=e.dataset.mfParallaxStaggerStepMobile?parseFloat(e.dataset.mfParallaxStaggerStepMobile):t<=u.breakpoints.tablet&&null!=e.dataset.mfParallaxStaggerStepTablet?parseFloat(e.dataset.mfParallaxStaggerStepTablet):null!=e.dataset.mfParallaxStaggerStep?parseFloat(e.dataset.mfParallaxStaggerStep):t<=u.breakpoints.mobile?u.stagger.mobileStep:t<=u.breakpoints.tablet?u.stagger.tabletStep:u.stagger.step;return Number.isFinite(n)?n:0}(e),a=(e.dataset.mfParallaxStaggerDirection??u.stagger.direction).toLowerCase(),i=Array.from(e.children).filter(e=>!e.hasAttribute("data-mf-parallax-stagger-ignore")),r=i.length;if(!r)return;const o=Math.floor((r-1)/2);i.forEach((e,i)=>{let s=i;"right"===a&&(s=r-1-i),"center"===a&&(s=Math.abs(i-o));const l=t+n*s,c=Math.round(1e3*l)/1e3;e.dataset.mfParallax="",e.dataset.mfParallaxSpeed=String(c),e.dataset.mfParallaxLocked="true"})}),document.querySelectorAll("[data-mf-parallax]").forEach(e=>{if(e.hasAttribute("data-mf-parallax-ignore"))return;const n=m(e);0!==n&&(e.style.willChange="transform",t.push({el:e,speed:n,docTop:f(e),currentY:0,targetY:0}))}),t.length&&(o=()=>{n=window.scrollY,a||(a=!0,requestAnimationFrame(e))},s=()=>{n=window.scrollY,t.forEach(e=>{e.speed=m(e.el),e.docTop=f(e.el)}),a||(a=!0,requestAnimationFrame(e))},n=window.scrollY,e(),window.addEventListener("scroll",o,{passive:!0}),window.addEventListener("resize",s)))}function g(e=!0){i=!1,window.removeEventListener("scroll",o),window.removeEventListener("resize",s),r&&cancelAnimationFrame(r),r=null,e&&t.forEach(e=>{e.el.style.transform="",e.el.style.willChange=""}),t=[],a=!1}return p(),{refresh:function(){g(!1),p()},destroy:g}}function a(e={}){let t=[],n=!1,a=!1,i=null,r=null;const o=window.matchMedia("(prefers-reduced-motion: reduce)").matches,s={from:0,once:!1,repeat:"both",duration:1200,trigger:"top 90%",...e.count||{}};function l(e){const t=parseFloat(String(e).replace(/,/g,""));return Number.isFinite(t)?t:null}function c(e){const t=String(e).split(".");return t[1]?t[1].length:0}function d(e,t,n,a=!0){return Number(e).toLocaleString(t,{minimumFractionDigits:n,maximumFractionDigits:n,useGrouping:a})}function u(e){e.animating=!1,e.rafId&&cancelAnimationFrame(e.rafId),e.rafId=null,e.startTime=null}function m(){const e=new Map(t.map(e=>[e.el,e])),n=document.querySelectorAll("[data-mf-count-to]"),a=[];n.forEach(t=>{const n=t.getAttribute("data-mf-count-to");if(!n)return;const i=l(n);if(null===i)return;const r=t.dataset.mfCountFrom,o=void 0!==r?l(r)??0:s.from??0,u=c(n),m=c(r||""),f=Math.max(u,m),p=function(e){const t=String(e).trim();return/^\d{1,3}(,\d{3})+(\.\d+)?$/.test(t)?"us":/^\d{1,3}(,\d{2})+(,\d{3})(\.\d+)?$/.test(t)?"in":"plain"}(n);let g,h=!0;"us"===p?g="en-US":"in"===p?g="en-IN":h=!1;const b=Number(t.dataset.mfCountDuration??s.duration),y=void 0!==t.dataset.mfCountOnce?"true"===t.dataset.mfCountOnce||""===t.dataset.mfCountOnce:s.once,w=String(t.dataset.mfCountRepeat??s.repeat).toLowerCase(),v=function(e){if(!e)return{elementAnchor:"top",viewportAnchor:90};const t=String(e).trim().toLowerCase().split(/\s+/);return{elementAnchor:t[0]||"top",viewportAnchor:t[1]?.endsWith("%")?parseInt(t[1],10):{top:0,center:50,bottom:100}[t[1]]??90}}(t.dataset.mfCountTrigger??s.trigger),S=e.get(t);S?(Object.assign(S,{from:o,target:i,locale:g,useGrouping:h,duration:b,once:y,repeat:w,trigger:v,fromDecimals:m,toDecimals:u,animDecimals:f}),a.push(S),e.delete(t)):(t.textContent=d(o,g,m,h),a.push({el:t,from:o,target:i,locale:g,useGrouping:h,duration:b,once:y,repeat:w,trigger:v,fromDecimals:m,toDecimals:u,animDecimals:f,started:!1,animating:!1,startTime:null,rafId:null}))}),e.forEach(u),t=a}function f(e,t){if(!t.animating)return;t.startTime||(t.startTime=e);const n=Math.min((e-t.startTime)/t.duration,1),a=t.from+(t.target-t.from)*n,i=t.animDecimals>0?Number(a.toFixed(t.animDecimals)):a;t.el.textContent=d(i,t.locale,t.animDecimals,t.useGrouping),n<1?t.rafId=requestAnimationFrame(e=>f(e,t)):(t.animating=!1,t.el.textContent=d(t.target,t.locale,t.toDecimals,t.useGrouping))}function p(){const e=window.innerHeight;t.forEach(t=>{const n=t.el.getBoundingClientRect(),a=function(e,t){return"center"===t?e.top+e.height/2:"bottom"===t?e.bottom:e.top}(n,t.trigger.elementAnchor),i=a<e*t.trigger.viewportAnchor/100&&n.bottom>0,r=n.bottom<=0,s=n.top>=e;if(i&&!t.started&&(t.started=!0,o?t.el.textContent=d(t.target,t.locale,t.toDecimals,t.useGrouping):(u(t),t.animating=!0,t.startTime=null,t.rafId=requestAnimationFrame(e=>f(e,t)))),!t.once&&t.started){("top"===t.repeat&&r||"bottom"===t.repeat&&s||"both"===t.repeat&&(r||s))&&(u(t),t.started=!1,t.el.textContent=d(t.from,t.locale,t.fromDecimals,t.useGrouping))}}),n=!1}function g(){n||(n=!0,requestAnimationFrame(p))}function h(e=!0){a=!1,window.removeEventListener("scroll",i),window.removeEventListener("resize",r),t.forEach(t=>{u(t),e&&(t.el.textContent=d(t.from,t.locale,t.fromDecimals,t.useGrouping))}),t=[],n=!1}return a&&h(!1),a=!0,m(),p(),i=g,r=g,window.addEventListener("scroll",i,{passive:!0}),window.addEventListener("resize",r),{refresh:function(){m(),g()},destroy:h}}function i(e={}){let t=[],n=!1,a=!1,i=null,r=null;const o=window.matchMedia("(prefers-reduced-motion: reduce)").matches,s={from:0,once:!1,repeat:"both",duration:1200,trigger:"top 90%",...e.roller||{}};function l(e){if(!e)return{elementAnchor:"top",viewportAnchor:90};const t=String(e).trim().toLowerCase().split(/\s+/);return{elementAnchor:t[0]||"top",viewportAnchor:t[1]?.endsWith("%")?parseInt(t[1],10):{top:0,center:50,bottom:100}[t[1]]??90}}function c(e){const t=function(e){return String(e||"").replace(/[^\d]/g,"")}(e);return t?parseInt(t,10):0}function d(e){return String(Math.abs(e)).length||1}function u(e,t,n){const a=e.querySelectorAll(".mf-roller-digit"),i=Math.max(0,t-n);a.forEach((e,t)=>{t<i?(e.style.width="0",e.style.opacity="0"):(e.style.width="",e.style.opacity="")})}function m(e,t,n,a,i=!1){const r=e.querySelectorAll(".mf-roller-digit-inner"),o=Math.max(0,n-a);let s=String(Math.abs(t));s=s.length>a?s.slice(-a):s.padStart(a,"0");for(let e=0;e<a;e++){const t=r[o+e];if(!t)continue;const n=parseInt(s[e],10);i?(t.style.transition="none",t.style.transform=`translateY(-${10*n}%)`,t.offsetHeight,t.style.transition=""):t.style.transform=`translateY(-${10*n}%)`}}function f(e){e.animating=!1,e.rafId&&cancelAnimationFrame(e.rafId),e.digitTimer&&clearInterval(e.digitTimer),e.rafId=null,e.digitTimer=null,e.startTime=null}function p(e){if(e.animating)return;f(e),e.animating=!0;let t=e.initialDigits;const n=e.targetDigits;let a=e.from;if(o)return u(e.el,e.totalDigits,n),m(e.el,e.to,e.totalDigits,n,!0),void(e.animating=!1);t!==n&&(e.digitTimer=setInterval(()=>{t+=t<n?1:-1,u(e.el,e.totalDigits,t),m(e.el,a,e.totalDigits,t,!0),t===n&&(clearInterval(e.digitTimer),e.digitTimer=null)},200)),e.rafId=requestAnimationFrame(function i(r){e.startTime||(e.startTime=r);const o=Math.min((r-e.startTime)/e.duration,1),s=Math.round(e.from+(e.to-e.from)*(l=o,1-Math.pow(1-l,3)));var l;a=s,m(e.el,s,e.totalDigits,t),o<1?e.rafId=requestAnimationFrame(i):(f(e),u(e.el,e.totalDigits,n),m(e.el,e.to,e.totalDigits,n,!0))})}function g(){const e=window.innerHeight;t.forEach(t=>{const n=t.el.getBoundingClientRect(),a=function(e,t){return"center"===t?e.top+e.height/2:"bottom"===t?e.bottom:e.top}(n,t.trigger.elementAnchor),i=a<e*t.trigger.viewportAnchor/100&&n.bottom>0,r=n.bottom<=0,o=n.top>=e;if(i&&!t.started&&(t.started=!0,p(t)),!t.once&&t.started){("top"===t.repeat&&r||"bottom"===t.repeat&&o||"both"===t.repeat&&(r||o))&&(t.started=!1,f(t),u(t.el,t.totalDigits,t.initialDigits),m(t.el,t.from,t.totalDigits,t.initialDigits,!0))}}),n=!1}function h(){a&&b(!1),a=!0,t=[],document.querySelectorAll("[data-mf-roller-to]").forEach(e=>{const n=e.getAttribute("data-mf-roller-to");if(!n)return;const a=c(n),i=e.dataset.mfRollerFrom,r=void 0!==i?c(i):s.from??0,o=d(a),f=d(r),p=Math.max(f,o);!function(e,t){const n=document.createElement("span");n.className="mf-roller";for(let e=0;e<t;e++){const e=document.createElement("span");e.className="mf-roller-digit",e.style.display="inline-block",e.style.overflow="hidden";const t=document.createElement("span");t.className="mf-roller-digit-inner",t.style.display="block",t.style.willChange="transform";for(let e=0;e<=9;e++){const n=document.createElement("span");n.textContent=e,n.style.display="block",t.appendChild(n)}e.appendChild(t),n.appendChild(e)}e.innerHTML="",e.appendChild(n)}(e,p),u(e,p,f),m(e,r,p,f,!0),t.push({el:e,from:r,to:a,duration:Number(e.dataset.mfRollerDuration??s.duration),trigger:l(e.dataset.mfRollerTrigger??s.trigger),once:void 0!==e.dataset.mfRollerOnce?"true"===e.dataset.mfRollerOnce||""===e.dataset.mfRollerOnce:s.once,repeat:String(e.dataset.mfRollerRepeat??s.repeat).toLowerCase(),initialDigits:f,targetDigits:o,totalDigits:p,started:!1,animating:!1,startTime:null,rafId:null,digitTimer:null})}),t.length&&(g(),i=()=>{n||(n=!0,requestAnimationFrame(g))},r=i,window.addEventListener("scroll",i,{passive:!0}),window.addEventListener("resize",r))}function b(e=!0){a=!1,window.removeEventListener("scroll",i),window.removeEventListener("resize",r),t.forEach(t=>{f(t),e&&(t.el.innerHTML="",t.el.textContent=String(t.from))}),t=[],n=!1}return h(),{init:h,refresh:function(){g()},destroy:b}}function r(e={}){if(window.matchMedia("(prefers-reduced-motion: reduce)").matches)return{refresh(){},destroy(){},pause(){},play(){},toggle(){}};const t={speed:80,direction:"left",pause:!1,pauseOnHover:!1,pauseOnVisibilityChange:!0},n="__MF_TICKER_SINGLETON__",a=window[n];if(a&&a.__isTickerSingleton)return a.updateOptions(e),a.refresh(),a.api;let i=[],r={...t,...e.ticker||{}},o=!1;const s=new WeakSet,l=window.devicePixelRatio||1;function c(){const e=new Map;i.forEach(t=>{e.set(t.container,t.isPaused()),t.cancel(),t.container.__mfTickerInited=!1}),i=[],document.querySelectorAll("[data-mf-ticker]").forEach(m),i.forEach(t=>{e.get(t.container)&&t.setPaused(!0)})}let d=null,u=null;function m(e){if(e.__mfTickerInited)return;e.__mfTickerInited=!0;const n=()=>{e.__mfTickerInited=!1};e.__mfTickerOriginalNodes||(e.__mfTickerOriginalNodes=Array.from(e.children));const a=e.__mfTickerOriginalNodes;if(!a.length)return void n();!function(e){if(s.has(e))return;const t=Array.from(e.querySelectorAll("img"));t.length&&Promise.all(t.map(e=>e.complete?Promise.resolve():new Promise(t=>{e.addEventListener("load",t,{once:!0}),e.addEventListener("error",t,{once:!0})}))).then(()=>{s.add(e),c()})}(e);const o=function(e,t){const n=String(e||"").toLowerCase();return["left","right","up","down"].includes(n)?n:t}(e.dataset.mfTickerDirection||r.direction,t.direction);let d=r.pauseOnVisibilityChange;"false"===e.dataset.mfTickerPauseOnVisibility&&(d=!1),"true"===e.dataset.mfTickerPauseOnVisibility&&(d=!0);const u={speed:Number(e.dataset.mfTickerSpeed)||r.speed,direction:o,pause:!0===r.pause,pauseOnHover:!0!==r.pause&&("true"===e.dataset.mfTickerPauseOnHover||!0===r.pauseOnHover),pauseOnVisibilityChange:d},m="left"===(f=u.direction)||"right"===f;var f;const p=(e=>"right"===e||"down"===e)(u.direction),g=document.createElement("div"),h=document.createElement("div");g.className="mf-ticker-viewport",h.className="mf-ticker-track",e.innerHTML="",e.appendChild(g),g.appendChild(h),m||(h.style.flexDirection="column");const b=document.createElement("div");b.className="mf-ticker-content",m||(b.style.flexDirection="column"),a.forEach(e=>b.appendChild(e)),h.appendChild(b);const y=()=>{const e=b.getBoundingClientRect();return m?e.width:e.height};let w=y();if(!w)return void n();const v=g.getBoundingClientRect()[m?"width":"height"];if(!v)return void n();let S=w,A=0;for(;S<v+w&&A<60;)a.forEach(e=>b.appendChild(e.cloneNode(!0))),S=y(),A++;const T=y();h.appendChild(b.cloneNode(!0));let x=p?-T:0,E=u.pause,C=!1,L=!1;const P=()=>E||C||L;function k(){e.classList.toggle("mf-ticker-paused",P())}let D=performance.now(),M=null;function F(e){const t=Math.round(e*l)/l;h.style.transform=m?`translate3d(${t}px,0,0)`:`translate3d(0,${t}px,0)`}F(x),k();const _=window.matchMedia("(hover: hover)").matches,q=()=>{E||L||(C=!0,k())},z=()=>{C=!1,k()};function I(){L=!0===document.hidden,D=performance.now(),k()}u.pauseOnHover&&_&&(g.addEventListener("mouseenter",q),g.addEventListener("mouseleave",z)),u.pauseOnVisibilityChange&&document.addEventListener("visibilitychange",I),M=requestAnimationFrame(function e(t){const n=(e=>Math.min(e,.05))((t-D)/1e3);if(D=t,!P()){const e=u.speed*n;x+=p?e:-e,!p&&x<=-T&&(x+=T),p&&x>=0&&(x-=T),F(x)}M=requestAnimationFrame(e)}),i.push({container:e,setPaused(e){E=e,k()},isPaused:P,cancel(){cancelAnimationFrame(M),u.pauseOnVisibilityChange&&document.removeEventListener("visibilitychange",I)}})}function f(e){if(!e)return i;const t=Array.from(document.querySelectorAll(e));return i.filter(e=>t.includes(e.container))}function p(){c()}const g={refresh:p,destroy:function(){clearTimeout(u),u=null,d?.disconnect(),d=null,i.forEach(e=>e.cancel()),i=[],document.querySelectorAll("[data-mf-ticker]").forEach(e=>{e.__mfTickerInited=!1}),o=!1;try{delete window[n]}catch(e){window[n]=null}},pause:function(e=null){f(e).forEach(e=>e.setPaused(!0))},play:function(e=null){f(e).forEach(e=>e.setPaused(!1))},toggle:function(e=null){f(e).forEach(e=>e.setPaused(!e.isPaused()))}};return window[n]={__isTickerSingleton:!0,api:g,refresh:p,updateOptions:function(e={}){r={...t,...e.ticker||{}}}},c(),!o&&document.fonts&&document.fonts.ready&&document.fonts.ready.then(()=>{o||(o=!0,c())}),function(){if(d)return;const e=()=>{clearTimeout(u),u=setTimeout(()=>{c()},80)};d=new MutationObserver(t=>{for(const n of t){if("attributes"===n.type&&n.attributeName&&n.attributeName.startsWith("data-mf-ticker"))return void e();if("childList"===n.type){const t=[...n.addedNodes,...n.removedNodes];for(const n of t)if(n&&1===n.nodeType&&(n.matches?.("[data-mf-ticker]")||n.querySelector?.("[data-mf-ticker]")))return void e()}}}),d.observe(document.body,{subtree:!0,childList:!0,attributes:!0})}(),g}function o(e,t=!1){return null==e||""===e?t:["true","1","yes"].includes(String(e).toLowerCase())}function s(e,t){const n=Number(e);return Number.isFinite(n)?n:t}const l=window.matchMedia("(prefers-reduced-motion: reduce)").matches,c=new Set;let d={},u=!1;function m(t={}){d=t,u&&p(),u=!0;const n=t.loop||{},a=t.typing||{};return document.querySelectorAll("[data-mf-text-type]").forEach(t=>{if(t.__mfTextInited)return;t.__mfTextInited=!0;let i=null;"loop"===t.dataset.mfTextType&&(i=function(t,n={}){const a=Array.from(t.children).filter(e=>e.textContent.trim().length);if(!a.length)return null;if(l)return a.forEach((e,t)=>{e.style.display=0===t?"":"none"}),{destroy(){}};const i=s(t.dataset.mfTextLoopInterval,n.interval??2e3),r=t.dataset.mfTextLoopAnimation??n.animation??"fade-up",o=s(t.dataset.mfTextLoopDuration,n.duration??500),c=t.dataset.mfTextLoopEasing??n.easing??"ease",d=e[c]||c,u=t.dataset.mfTextLoopDistance??n.distance??40;let m=0,f=null;return a.forEach((e,t)=>{e.style.whiteSpace="nowrap",e.style.display=0===t?"inline-block":"none",e.setAttribute("data-mf-animation",r),e.style.setProperty("--mf-duration",o+"ms"),e.style.setProperty("--mf-easing",d),null!=u&&e.style.setProperty("--mf-distance",u+"px"),e.classList.remove("mf-animate")}),requestAnimationFrame(()=>{a[0].classList.add("mf-animate")}),f=setInterval(function(){const e=a[m];e.classList.remove("mf-animate"),e.style.display="none",m=(m+1)%a.length;const t=a[m];t.style.display="inline-block",t.style.transition="none",t.classList.remove("mf-animate"),t.offsetHeight,t.style.transition="",t.classList.add("mf-animate")},i),{destroy(){clearInterval(f),a.forEach(e=>{e.style.display="",e.style.whiteSpace="",e.classList.remove("mf-animate"),e.style.removeProperty("--mf-duration"),e.style.removeProperty("--mf-easing"),e.style.removeProperty("--mf-distance"),e.removeAttribute("data-mf-animation")})}}}(t,n)),"typing"===t.dataset.mfTextType&&(i=function(e,t={}){const n=e.innerHTML,a=Array.from(e.children).map(e=>e.textContent.trim()).filter(Boolean);if(!a.length)return null;if(l)return e.textContent=a[0],{destroy(){e.innerHTML=n}};const i=s(e.dataset.mfTextTypingSpeed,t.speed??80),r=s(e.dataset.mfTextTypingDeleteSpeed,t.deleteSpeed??40),c=s(e.dataset.mfTextTypingInterval,t.interval??1200),d=o(e.dataset.mfTextTypingLoop,t.loop??!0),u=o(e.dataset.mfTextTypingCursor,t.cursor??!0),m=e.dataset.mfTextTypingCursorChar??t.cursorChar??"|",f=o(e.dataset.mfTextTypingCursorBlink,t.cursorBlink??!0);let p=0,g=0,h=!1,b=null;e.innerHTML="";const y=document.createElement("span");y.className="mf-sr-only",y.setAttribute("aria-live","polite"),y.setAttribute("aria-atomic","true"),y.textContent=a[0];const w=document.createElement("span");w.setAttribute("aria-hidden","true");const v=document.createTextNode("");w.appendChild(v);let S=null;return u&&(S=document.createElement("span"),S.className="mf-typing-cursor",S.textContent=m,S.setAttribute("aria-hidden","true"),f||S.classList.add("mf-typing-cursor-static"),w.appendChild(S)),e.appendChild(y),e.appendChild(w),function e(){const t=a[p];if(h){if(g--,v.textContent=t.slice(0,g),0===g){if(h=!1,p++,!d&&p>=a.length)return;p%=a.length}}else if(g++,v.textContent=t.slice(0,g),g===t.length)return y.textContent=t,d||p!==a.length-1?void(b=setTimeout(()=>{h=!0,e()},c)):void(S&&(S.style.display="none"));b=setTimeout(e,h?r:i)}(),{destroy(){clearTimeout(b),e.innerHTML=n}}}(t,a)),i&&c.add({el:t,instance:i})}),{refresh:f,destroy:p}}function f(){m(d)}function p(){c.forEach(({el:e,instance:t})=>{t.destroy?.(),delete e.__mfTextInited}),c.clear(),u=!1}let g=null,h=null,b=null,y=null,w=null,v=null,S=!1,A=!1,T=!1,x={};function E({destroyTicker:e=!1}={}){g?.destroy?.(),h?.destroy?.(),b?.destroy?.(),y?.destroy?.(),v?.destroy?.(),e&&(w?.destroy?.(),w=null),g=null,h=null,b=null,y=null,v=null}const C={init:function(e={}){return T=!0,x=e,S&&E({destroyTicker:!1}),v=m(!0===e.text?{}:e.text||{}),g=t(e),h=n(e),b=a(e),y=i(e),w=r(e),S=!0,C},destroy(){E({destroyTicker:!0}),S=!1},scroll:{init(){g||(g=t(x))},refresh(){g?.refresh?.()},destroy(){g?.destroy?.(),g=null}},parallax:{init(){h||(h=n(x))},refresh(){h?.refresh?.()},destroy(){h?.destroy?.(),h=null}},count:{init(){b||(b=a(x))},refresh(){b?.refresh?.()},destroy(){b?.destroy?.(),b=null}},roller:{init(){y||(y=i(x))},refresh(){y?.refresh?.()},destroy(){y?.destroy?.(),y=null}},ticker:{init(){w||(w=r(x))},refresh(){w?.refresh?.()},pause(e=null){w?.pause?.(e)},play(e=null){w?.play?.(e)},toggle(e=null){w?.toggle?.(e)},destroy(){w?.destroy?.(),w=null}},text:{init(){v||(v=m(!0===x.text?{}:x.text||{}))},refresh(){v?.refresh?.()},destroy(){v?.destroy?.(),v=null}}};return"undefined"!=typeof window&&document.addEventListener("DOMContentLoaded",()=>{T||A||(A=!0,C.init())}),C});
